*******************************************************************
* Robustness checks: Capitalize separately bonds and equities     *
*******************************************************************

set more off
clear 

foreach pas of  global yearliste{
	global year=`pas'
	dis `pas'
	if  ${year}>1984 {
		
	
* I) Organize the data
***************************		
	
	* Capital income and assets from National Accounts 
		import excel using "$param/GGP2016DINAAppendixA.xlsx",first clear sheet("statacapital") cellrange(A7:R71) 
		* Transform all parameters into global 
				foreach var of varlist _all {
					quiet sum `var' if year==${year}
					global `var'=r(mean)
				}	

	* Load the data
		use year- ndecl pac age pension_irpp_foy rente_irpp_foy salchom_irpp_foy nonsal_foy rfon_irpp_foy rfin_int_irpp_foy* rfin_int_bar_irpp_foy* rfin_div_irpp_foy* rfin_irpp_foy using  "$wfrev/rev${year}.dta",clear
		merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(nonsal_capital_cn)
		drop _merge
		* Small adjustments
			* keep only taxable interest at the progressive schedule the  interet for comparabilty issues
			replace rfin_int_irpp_foy =rfin_int_bar_irpp_foy
			if  ${year}<2005 {
				* Correction of case TS in income tax returns before 2004 in order to capitalize separately interest and dividends. See GGP2016WealthAppendix for more detailed explanations
					replace rfin_int_irpp_foy =rfin_int_bar_irpp_foy2
					replace rfin_div_irpp_foy =rfin_div_irpp_foy2
			}	
			
* II) Capitalization method for bonds and equities separately
****************************************************************		
		quiet sum rfin_int_irpp_foy [aw=pondn] if idnum==1
		gen patfin_int_cn_foy=rfin_int_irpp_foy*${patfin_intNA}/r(sum)*1000000000
		
		quiet sum rfin_div_irpp_foy [aw=pondn] if idnum==1
		gen patfin_div_cn_foy=rfin_div_irpp_foy*${patfin_divNA}/r(sum)*1000000000
		
		* Individualization: Divide by 2 among couples
		foreach var of newlist patfin_int patfin_div  {
			rename `var'_cn_foy `var'_corTS
			replace `var'_corTS=`var'_corTS/2 if ndecl==2 & pac==0
			replace `var'_corTS=0 if pac==1 & idnum~=1
		}
		
		* Rounding errors and check
		foreach var of newlist patfin_int patfin_div   {
			sum `var'_corTS [aw=pondn]
			dis r(sum)/${`var'NA}/1000000000
			replace `var'_corTS=`var'_corTS*${`var'NA}*1000000000/r(sum)
		}
	
		merge 1:1 year idfoy idindiv using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keepusing(patfin_div_cn patfin_int_cn pat_cn)
		drop _merge
		gen pat_corTS = pat_cn-patfin_div_cn -patfin_int_cn+patfin_int_corTS+ patfin_div_corTS
		drop patfin_div_cn patfin_int_cn pat_cn
		keep year idfoy idnum idindiv pondn pat_corTS patfin_int_corTS patfin_div_corTS
		order year idfoy idnum idindiv pondn pat_corTS patfin_int_corTS patfin_div_corTS	

		save "$wfrobust/corTS/revcapwealthcn${year}_corTS.dta",replace	
		
	macro drop  revfon_fictifNA revavieNA revfonNA revdivNA revliquNA revintNA patproNA patfin_intNA patfin_divNA patfin_avNA patfon_rentnetNA patfon_ownernetNA patfin_liquNA  patfon_ownerbrutNA	patfon_rentbrutNA	passif_ownerNA	passif_rentNA
	}
}


